#include <stdio.h>
#include <libldiag.h>
#include <string.h>

#include "enclosure.h"

extern void query_enclosure(struct enclosure *ep);

char *Switchfile;
char *Tmpdir = "/tmp";

void
dump_linecard(int slot, struct slotdesc *sp)
{
  int i;
  
  printf("%d xbar ports and %d fiber ports\n", sp->num_xp, sp->num_fiber);

  for (i=0; i<sp->num_xp; ++i) {
    printf("Xbarport %d:\n", i);
    printf("         portno %d\n", sp->xp[i].portno);
 printf("%d:%d ", slot, i);
    printf("  invalidroutes %d\n", sp->xp[i].vals.invalidroutes);
    printf("       goodcrcs %d\n", sp->xp[i].vals.goodcrcs);
    printf("        badcrcs %d\n", sp->xp[i].vals.badcrcs);
  }
  for (i=0; i<sp->num_fiber; ++i) {
    printf("Fiberport %d:\n", i);
    printf("     signallost %d\n", sp->fp[i].vals.signallost);
    printf("signallostcount %d\n", sp->fp[i].vals.signallostcount);
  }
}

int
main(int argc, char **argv)
{
  struct enclosure enc;
  char *sw_name;
  int i;
  
  if (argc > 1) {
    sw_name = argv[1];
  } else {
    sw_name = "atipaswitch";
  }

  /* start with a nice, empty structure */
  bzero(&enc, sizeof(enc));
  strcpy(enc.name, sw_name);

  query_enclosure(&enc);

  printf("%d backplane slots and %d pluggable\n",
	enc.num_bp_slots, enc.num_ext_slots);

  for (i=0; i<MAX_SLOT; ++i) {
    if (enc.slot[i] != NULL) {
      printf("\n------slot %d---------\n", i);
      dump_linecard(i, enc.slot[i]);
    }
  }

  exit(0);
}
